/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.schedops.schedulables;

import com.ibm.hwmca.base.bpcrcon.BackupCriticalConsoleData;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.schedops.HMCSchedulable;
import com.ibm.hwmca.fw.schedops.OperationTarget;
import com.ibm.hwmca.fw.schedops.Schedulable;
import com.ibm.hwmca.fw.schedops.SchedulableDescriptor;
import com.ibm.hwmca.fw.schedops.SchedulableException;
import com.ibm.hwmca.fw.schedops.ScheduledOperation;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;

public class BackupHardDiskSchedulable
implements HMCSchedulable {
    private static final String CLASS_NAME = "[BackupHardDiskSchedulable] ";
    private static final String TRACE_MASKT = "XTIMxxxT";
    private static final String TRACE_MASKF = "XTIMxxxF";
    private static final String TRACE_MASKD = "XTIMxxxD";
    private SchedulableDescriptor descriptor = null;

    public BackupHardDiskSchedulable() {
        Trace.trace(TRACE_MASKT, "[BackupHardDiskSchedulable] <> BackupHardDiskSchedulable()");
    }

    protected BackupHardDiskSchedulable(PersistentData data) {
        Trace.trace(TRACE_MASKT, "[BackupHardDiskSchedulable] <> BackupHardDiskSchedulable( PersistentData )");
    }

    public synchronized SchedulableDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new Descriptor();
        }
        return this.descriptor;
    }

    public Object performScheduledOperation(ScheduledOperation schedop) throws SchedulableException {
        Trace.trace(TRACE_MASKT, "[BackupHardDiskSchedulable] >> performScheduledOperation()");
        BackupCriticalConsoleData backupSchedulable = null;
        try {
            backupSchedulable = new BackupCriticalConsoleData();
            backupSchedulable.performBackup();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "[BackupHardDiskSchedulable] rethrowing exception from BackupCriticalConsoleData" + e);
            String[] parms = new String[]{backupSchedulable.backupErrorsLong(backupSchedulable.getState()).toString()};
            FrameworkEventText fet = new FrameworkEventText(860, parms);
            new SystemEventLog(fet, "BPCRCON_FAIL").log();
            throw new SchedulableException(e);
        }
        FrameworkEventText fet = new FrameworkEventText(861);
        new SystemEventLog(fet, "BPCRCON_COMP").log();
        Trace.trace(TRACE_MASKT, "[BackupHardDiskSchedulable] << performScheduledOperation()");
        return null;
    }

    public PersistentData getPersistentData() {
        return new PersistedData();
    }

    public boolean isUpgradeData() {
        return false;
    }

    public static class Descriptor
    implements SchedulableDescriptor {
        public LocalizableText getDescription() {
            return new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", "XTIM.BACKUP");
        }

        public Schedulable createSchedulable(OperationTarget target) {
            return new BackupHardDiskSchedulable();
        }

        public boolean isDisplayableOnUI(OperationTarget target) {
            return true;
        }

        public boolean isSelectableOnUI(OperationTarget target) {
            return true;
        }

        public String getOperationParametersTasklet() {
            return null;
        }
    }

    private static class PersistedData
    implements PersistentData {
        private PersistedData() {
        }
    }
}

